<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Division extends Model 
{

    protected $table = 'divisions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'slug', 'gender');

    public function athletes()
    {
        return $this->hasMany('App\Models\Athlete');
    }

    public function trainers()
    {
        return $this->belongsToMany('App\Models\Trainer');
    }

}